***********************************************************************
*** Table E1: Alternative transformations ***
************************************************************************                
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

bysort country_id : gen dglobal_real_credit = log(global_real_credit) - log(L4.global_real_credit)
bysort country_id : gen dglobal_real_hp = log(global_real_hp) - log(L4.global_real_hp)
bysort country_id : gen dglobal_credit_gdp = (global_credit_gdp - L4.global_credit_gdp)
bysort country_id : gen dglobal_hp_inc = (global_hp_inc - l4.global_hp_inc)
label variable dglobal_credit_gdp "Global credit-to-GDP (yd)"
label variable dglobal_hp_inc "Global house prices-to-income (yd)"
label variable dlogreal_hcredit "Real household credit growth(yoy)"
label variable dlogreal_nfecredit "Real firm credit growth(yoy)"
label variable dlogrGDP "Real GDP growth(yoy)"
label variable dglobal_real_credit "Global real credit growth(yoy)"
label variable dglobal_real_hp "Global real house price growth (yoy)"

*Column (1)
logit crisis4_12 dhcredit_gdp dnfecredit_gdp dhp_disp_inc gdp_gap i.country_id, robust cluster(period)
est store pa1
predict pa1, p
bysort start_crisis : count if pa1 !=.
roctab crisis4_12 pa1
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 20
estadd scalar Crisis = 29

*Column (2)
logit crisis4_12 dhcredit_gdp dnfecredit_gdp dhp_disp_inc dglobal_credit_gdp dglobal_hp_inc gdp_gap i.country_id, robust cluster(period)
est store pa2
predict pa2, p
bysort start_crisis : count if pa2 !=.
roctab crisis4_12 pa2
estadd scalar AUROC = r(area)
estadd scalar Countries = 17
estadd scalar Crisis = 25

*Column (3)
logit crisis4_12 dhcredit_gdp dnfecredit_gdp dhp_disp_inc dglobal_credit_gdp dglobal_hp_inc ind_hp_inc_exu ind_credit_gdp_exu gdp_gap i.country_id, robust cluster(period)
est store pa3
predict pa3, p
bysort start_crisis : count if pa3 !=.
roctab crisis4_12 pa3
estadd scalar AUROC = r(area)
estadd scalar Countries = 15
estadd scalar Crisis = 22

*Column (4)
logit crisis4_12 dhcredit_gdp dnfecredit_gdp dhp_disp_inc dwholesale_assets equity_assets dglobal_credit_gdp dglobal_hp_inc ind_hp_inc_exu ind_credit_gdp_exu gdp_gap i.country_id, robust cluster(period)
est store pa4
predict pa4, p
bysort start_crisis : count if pa4 !=.
roctab crisis4_12 pa4
estadd scalar AUROC = r(area)
estadd scalar Countries = 13
estadd scalar Crisis = 19

cd "$outputTables"
esttab pa1 pa2 pa3 pa4 using TableE1.tex, se indicate("Country fixed effects = *country_id") drop(_cons) ///
						order(dhcredit_gdp dnfecredit_gdp dglobal_credit_gdp  dglobal_hp_inc ind_hp_inc_exu ind_credit_gdp_exu gdp_gap) ///
						star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
						label scalars("r2_p Pseudo R-Squared" AUROC Countries Crisis) ///
						nodepvars nonotes replace

